package control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JTextField;

import model.Catalogo;
import model.Pezzo;
import model.ProxyPezzo;

public class EnterListener implements ActionListener {

	private ProxyPezzo pezzo;
	private Catalogo catalogo;
	private JTextField pezzotext, date, descr;
	private JComboBox<String> sala;

	public EnterListener(Catalogo catalogo, JTextField pezzotext,
			JTextField date, JTextField descr, JComboBox<String> sala) {
		this.catalogo = catalogo;
		this.pezzotext = pezzotext;
		this.date = date;
		this.sala = sala;
		this.descr = descr;

	}

	@Override
	public void actionPerformed(ActionEvent e) {

		pezzo = new ProxyPezzo(new Pezzo());

		pezzo.setCodeID(pezzotext.getText());
		pezzo.setDate(Integer.parseInt(date.getText()));
		pezzo.setDescription(descr.getText());
		pezzo.setSala(sala.getSelectedItem().toString());
		catalogo.addPezzo(pezzo);

	}

}